/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import vectorwing.farmersdelight.utils.tags.ModTags;

public class PieBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final IntegerProperty BITES = IntegerProperty.func_177719_a((String)"bites", (int)0, (int)3);
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    public final Supplier<Item> pieSlice;

    public PieBlock(AbstractBlock.Properties properties, Supplier<Item> pieSlice) {
        super(properties);
        this.pieSlice = pieSlice;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getPieSliceItem() {
        return new ItemStack((IItemProvider)this.pieSlice.get());
    }

    public int getMaxBites() {
        return 4;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            if (ModTags.KNIVES.func_230235_a_((Object)itemstack.func_77973_b())) {
                return this.cutSlice(worldIn, pos, state);
            }
            if (this.consumeBite(worldIn, pos, state, player) == ActionResultType.SUCCESS) {
                return ActionResultType.SUCCESS;
            }
            if (itemstack.func_190926_b()) {
                return ActionResultType.CONSUME;
            }
        }
        if (ModTags.KNIVES.func_230235_a_((Object)itemstack.func_77973_b())) {
            return this.cutSlice(worldIn, pos, state);
        }
        return this.consumeBite(worldIn, pos, state, player);
    }

    protected ActionResultType consumeBite(World worldIn, BlockPos pos, BlockState state, PlayerEntity playerIn) {
        int bites;
        if (!playerIn.func_71043_e(false)) {
            return ActionResultType.PASS;
        }
        ItemStack slice = this.getPieSliceItem();
        Food sliceFood = slice.func_77973_b().func_219967_s();
        playerIn.func_71024_bL().func_221410_a(slice.func_77973_b(), slice);
        if (this.getPieSliceItem().func_77973_b().func_219971_r() && sliceFood != null) {
            for (Pair pair : sliceFood.func_221464_f()) {
                if (worldIn.field_72995_K || pair.getFirst() == null || !(worldIn.field_73012_v.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                playerIn.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
            }
        }
        if ((bites = ((Integer)state.func_177229_b((Property)BITES)).intValue()) < this.getMaxBites() - 1) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            worldIn.func_217377_a(pos, false);
        }
        worldIn.func_184133_a(null, pos, SoundEvents.field_187537_bA, SoundCategory.PLAYERS, 0.8f, 0.8f);
        return ActionResultType.SUCCESS;
    }

    protected ActionResultType cutSlice(World worldIn, BlockPos pos, BlockState state) {
        int bites = (Integer)state.func_177229_b((Property)BITES);
        if (bites < this.getMaxBites() - 1) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            worldIn.func_217377_a(pos, false);
        }
        InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.getPieSliceItem());
        worldIn.func_184133_a(null, pos, SoundEvents.field_187546_ae, SoundCategory.PLAYERS, 0.8f, 0.8f);
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, BITES});
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return this.getMaxBites() - (Integer)blockState.func_177229_b((Property)BITES);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

